<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.marketer'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('marketer.index')); ?>"><?php echo app('translator')->get('sidebar.marketer'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="#">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-4">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.marketer_code'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="marketer_code" value="<?php echo e(request()->input('marketer_code')); ?>" autocomplete="off">
                                    </fieldset>
                                </div>

                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('global.search'); ?></button>
                                <a href="<?php echo e(route('marketer.index')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    <?php echo app('translator')->get('global.clear_search'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admins_create')): ?>
                                                <div class="col-2 text-right">
                                                    <a href="<?php echo e(route('marketer.create')); ?>" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.discount_percentage'); ?></th>
                                                        <th><?php echo app('translator')->get('global.marketer_code'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $marketers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $marketer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr class="text-center">
                                                            <td><?php echo e($loop->iteration); ?></td>
                                                            <td><?php echo e($marketer->name_en); ?></td>
                                                            <td><?php echo e($marketer->discount_percentage); ?></td>
                                                            <td><?php echo e($marketer->marketer_code); ?></td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('marketers_edit')): ?>
                                                                        <a href="<?php echo e(route('marketer.edit', $marketer->id)); ?>"
                                                                           title="<?php echo app('translator')->get('global.edit'); ?>"
                                                                           class="btn btn-primary btn-sm ml-1"><i
                                                                                class="fa fa-edit"></i></a>
                                                                    <?php endif; ?>
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('marketers_delete')): ?>
                                                                        <form
                                                                            action="<?php echo e(route('marketer.destroy', $marketer->id)); ?>"
                                                                            method="post">
                                                                            <?php echo method_field("delete"); ?>
                                                                            <?php echo csrf_field(); ?>
                                                                            <button
                                                                                class="btn btn-sm btn-danger ml-1 deleteBtn"
                                                                                type="button"
                                                                                title="<?php echo app('translator')->get('global.delete'); ?>"><i
                                                                                    class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    <?php endif; ?>
                                                                    <a href="<?php echo e(route('marketer.show', $marketer->id)); ?>"
                                                                       title="<?php echo app('translator')->get('global.view'); ?>"
                                                                       class="btn btn-primary btn-sm ml-1"><i
                                                                            class="fa fa-eye"></i></a>

                                                                </div>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="7"
                                                                class="text-center"><?php echo app('translator')->get('global.no_marketers'); ?></td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    </tbody>

                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($marketers->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .vertical-line {
            display: inline-block;
            border-left: 1px solid #f34b4b;
            margin: 0 10px;
            height: 125px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/marketer/index.blade.php ENDPATH**/ ?>