<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.marketer'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('marketer.index')); ?>"><?php echo app('translator')->get('sidebar.marketer'); ?></a>
            </li>
            <li class="breadcrumb-item active"><?php echo app('translator')->get('global.create'); ?>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section id="column-selectors">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <form class="form" action="<?php echo e(route('marketer.store')); ?>" method="post"
                                  enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="row mb-2">
                                        <div class="col-md-3 col-lg-3 col-6 text-center ProductImage"></div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.name_en'); ?></label>
                                                    <input class="form-control" name="name_en" value=""
                                                           autocomplete="off" placeholder="Name">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.name_ar'); ?></label>
                                                    <input class="form-control" name="name_ar" value=""
                                                           autocomplete="off" placeholder="Name">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-6">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.discount_percentage'); ?></label>
                                                    <input class="form-control" name="discount_percentage" value=""
                                                           autocomplete="off" placeholder="Name">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 col-4">
                                            <div class="form-group">
                                                <div class="controls">
                                                    <label><?php echo app('translator')->get('global.marketer_code'); ?></label>
                                                    <input class="form-control" name="marketer_code" id="marketer_code"
                                                           autocomplete="off" placeholder="Name">
                                                    <div class="help-block"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2 col-2">
                                            <div class="form-group">
                                            <div class="controls" style="margin-top: 18px !important;">
                                                <button class="btn btn-warning mr-1 mb-1 waves-effect waves-light"
                                                        id="generate_btn"><?php echo app('translator')->get('global.generate'); ?>
                                                </button>
                                            </div>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="col-12 text-center" st>
                                        <button type="submit"
                                                class="btn btn-primary mr-1 mb-1 waves-effect waves-light saveBtn">حفظ
                                        </button>
                                        <a href="<?php echo e(route('marketer.index')); ?>"
                                           class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">الغاء</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function () {
            $("#generate_btn").click(function (e) {
                e.preventDefault();
                // $("#marketer_code").val(genRand(8));

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('getMarketerCode')); ?>",
                    data: {_token: "<?php echo e(csrf_token()); ?>"},
                    success: function(response) {
                        $("#marketer_code").val(response.marketerCode)
                    },
                    error: function() {
                        swal.fire(
                            'Error!',
                            'Sorry! Something went wrong',
                            'error'
                        )
                    }
                });

            });
        });


        const genRand = (len) => {
            return Math.random().toString(36).substring(2,len+2);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/marketer/create.blade.php ENDPATH**/ ?>