<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.countries'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.master_data'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('countries.index')); ?>"><?php echo app('translator')->get('sidebar.countries'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="<?php echo e(route("countries.index")); ?>">
                            <div class="row">
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.name'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="<?php echo e(request()->input('name')); ?>" autocomplete="off">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-6 col-lg-6">
                                    <label for="users-list-verified"><?php echo app('translator')->get('global.active'); ?></label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                            <option value="1" <?php echo e(request()->input('is_active') === "1" ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                            <option value="0" <?php echo e(request()->input('is_active') === "0" ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('global.search'); ?></button>
                                <a href="<?php echo e(route('countries.index')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    <?php echo app('translator')->get('global.clear_search'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('countries_create')): ?>
                                            <div class="col-2 text-right">
                                                <a href="<?php echo e(route('countries.create')); ?>" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.currency'); ?></th>
                                                        <th><?php echo app('translator')->get('global.code'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__empty_1 = true; $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                            <tr class="text-center">
                                                                <td><?php echo e($loop->iteration); ?></td>
                                                                <td><?php echo e($country->name); ?></td>
                                                                <td><?php echo e($country->currency); ?></td>
                                                                <td><?php echo e($country->code); ?></td>
                                                                <td class="is_active"><i class="fa fa-<?php echo e($country->is_active ? "check text-success" : "times text-danger"); ?>"></i></td>
                                                                <td>
                                                                    <div class="d-inline-flex action-btn">
                                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('countries_edit')): ?>
                                                                            <a href="<?php echo e(route('countries.edit', $country->id)); ?>" title="<?php echo app('translator')->get('global.edit'); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>

                                                                            <?php if($country->is_active): ?>
                                                                                <a href="#" title="<?php echo app('translator')->get('global.deactivate'); ?>" data-id="<?php echo e($country->id); ?>" data-route="<?php echo e(route('toggleCountryStatus')); ?>" data-message="<?php echo app('translator')->get('global.deactivate_country'); ?>" data-alt-msg="<?php echo app('translator')->get('global.activate_country'); ?>" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                            <?php else: ?>
                                                                                <a href="#" title="<?php echo app('translator')->get('global.activate'); ?>" data-id="<?php echo e($country->id); ?>" data-route="<?php echo e(route('toggleCountryStatus')); ?>" data-message="<?php echo app('translator')->get('global.activate_country'); ?>" data-alt-msg="<?php echo app('translator')->get('global.deactivate_country'); ?>" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                            <?php endif; ?>







                                                                        <?php endif; ?>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                            <tr>
                                                                <td colspan="7" class="text-center"><?php echo app('translator')->get('global.no_countries'); ?></td>
                                                            </tr>
                                                        <?php endif; ?>
                                                        <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.code'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($countries->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/master-data/countries/index.blade.php ENDPATH**/ ?>