<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.roles'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('roles.index')); ?>"><?php echo app('translator')->get('sidebar.roles'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions_create')): ?>
                                                <div class="col-2 text-right">
                                                    <a href="<?php echo e(route('roles.create')); ?>" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.users_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.permissions_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr class="text-center">
                                                            <td><?php echo e($loop->iteration); ?></td>
                                                            <td><?php echo e(getRoleName($role)); ?></td>

                                                            <td><?php echo e($role->users()->count()); ?></td>
                                                            <td><?php echo e($role->permissions()->count()); ?></td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions_edit')): ?>
                                                                        <a href="<?php echo e(route('roles.edit', $role->id)); ?>" title="<?php echo app('translator')->get('global.edit'); ?>" class="btn btn-primary btn-sm ml-1"><i class="fa fa-edit"></i></a>
                                                                    <?php endif; ?>
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions_delete')): ?>
                                                                        <form action="<?php echo e(route('roles.destroy', $role->id)); ?>" method="post">
                                                                            <?php echo method_field("delete"); ?>
                                                                            <?php echo csrf_field(); ?>
                                                                            <button class="btn btn-sm btn-danger ml-1 deleteBtn" type="button" title="<?php echo app('translator')->get('global.delete'); ?>"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    <?php endif; ?>

                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="7" class="text-center"><?php echo app('translator')->get('global.no_permissions'); ?></td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.users_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.permissions_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($roles->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/administrator/roles/index.blade.php ENDPATH**/ ?>