<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.products'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.users_management'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('products.index')); ?>"><?php echo app('translator')->get('sidebar.products'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="<?php echo e(route("products.index")); ?>">
                            <div class="row">
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.shop_name'); ?></label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="user_id" id="users-list-verified">
                                            <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                            <?php $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($shop): ?>
                                                    <option value="<?php echo e($shop->id); ?>" <?php echo e(request()->input('user_id') == $shop->id ? "selected" : ""); ?>>
                                                        <?php echo e($shop->display_shop_name != '' ? $shop->display_shop_name : (App::getLocale() == 'en' ? 'Uncompleted Info' : 'المعلومات غير مكتلمة')); ?></option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.category_name'); ?></label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="category_id" id="users-list-verified">
                                            <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e(request()->input('category_id') == $category->id ? "selected" : ""); ?>>
                                                    <?php echo e($category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-2 col-lg-2">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.price_less'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="price" value="<?php echo e(request()->input('price')); ?>" autocomplete="off">
                                    </fieldset>
                                </div>
                                
                                <div class="col-12 col-sm-2 col-lg-2">
                                    <label for="users-list-verified"><?php echo app('translator')->get('global.active'); ?></label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                            <option value="1" <?php echo e(request()->input('is_active') === "1" ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                            <option value="0" <?php echo e(request()->input('is_active') === "0" ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                        </select>
                                    </fieldset>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('global.search'); ?></button>
                                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    <?php echo app('translator')->get('global.clear_search'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_create')): ?>
                                                <div class="col-2 text-right">
                                                    <a href="<?php echo e(route('products.create')); ?>" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.shop_name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.category'); ?></th>
                                                        <th><?php echo app('translator')->get('global.price'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.approved'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr class="text-center">
                                                            <td><?php echo e($loop->iteration); ?></td>
                                                            <td>
                                                                <div class="pr-1">
                                                                        <span class="avatar m-0 avatar-md">
                                                                            <a href="<?php echo e($product->default_image); ?>" class="mpImage">
                                                                            <img class="media-object rounded-circle" src="<?php echo e($product->default_image); ?>" height="42" width="42" alt="Generic placeholder image">
                                                                            </a>
                                                                            <i></i>
                                                                        </span>
                                                                </div>
                                                            </td>
                                                            <td><a href="<?php echo e(route('shops.edit', $product->user_id)); ?>"><?php echo e(optional($product->shop)->display_shop_name); ?></a></td>
                                                            <td><?php echo e(optional($product->category)->name); ?></td>
                                                            <td><?php echo e($product->price .' '.($product->price > 0 ?trans('global.qar') : '-')); ?></td>
                                                            
                                                            <td class="is_active"><i class="fa fa-<?php echo e($product->is_active ? "check text-success" : "times text-danger"); ?>"></i></td>
                                                            <td class="is_approved"><i class="fa fa-<?php echo e($product->is_approved ? "check text-success" : "times text-danger"); ?>"></i></td>

                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_edit')): ?>
                                                                        <a href="<?php echo e(route('products.edit', $product->id)); ?>" title="<?php echo app('translator')->get('global.edit'); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>
                                                                        <?php if($product->is_active): ?>
                                                                            <a href="#" title="<?php echo app('translator')->get('global.deactivate'); ?>" data-id="<?php echo e($product->id); ?>" data-route="<?php echo e(route('toggleProductStatus')); ?>" data-message="<?php echo app('translator')->get('global.deactivate_product'); ?>" data-alt-msg="<?php echo app('translator')->get('global.activate_product'); ?>" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                        <?php else: ?>
                                                                            <a href="#" title="<?php echo app('translator')->get('global.activate'); ?>" data-id="<?php echo e($product->id); ?>" data-route="<?php echo e(route('toggleProductStatus')); ?>" data-message="<?php echo app('translator')->get('global.activate_product'); ?>" data-alt-msg="<?php echo app('translator')->get('global.deactivate_product'); ?>" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_approval')): ?>

                                                                            <a href="#" title="<?php echo app('translator')->get('global.disapproved'); ?>" data-type="disappove" data-id="<?php echo e($product->id); ?>" data-route="<?php echo e(route('toggleProductApproval')); ?>" data-message="<?php echo app('translator')->get('global.disapprove_product'); ?>" data-alt-msg="<?php echo app('translator')->get('global.approve_product'); ?>" class="btn btn-secondary  btn-sm toggleIsApprove"><i class="fas fa-eye-slash"></i></a>

                                                                            <a href="#" <?php if($product->is_approved): ?>  disabled="" <?php endif; ?>  title="<?php echo app('translator')->get('global.approved'); ?>" data-id="<?php echo e($product->id); ?>" data-route="<?php echo e(route('toggleProductApproval')); ?>" data-message="<?php echo app('translator')->get('global.approve_product'); ?>" data-alt-msg="<?php echo app('translator')->get('global.disapprove_product'); ?>" class="btn btn-success  btn-sm toggleIsApprove"><i class="fas fa-eye"></i></a>

                                                                    <?php endif; ?>
                                                                    
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_delete')): ?>
                                                                        <form action="<?php echo e(route('products.destroy', $product->id)); ?>" method="post">
                                                                            <?php echo method_field("delete"); ?>
                                                                            <?php echo csrf_field(); ?>
                                                                            <button class="btn btn-sm btn-danger deleteBtnRsn" type="button" title="<?php echo app('translator')->get('global.delete'); ?>"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="10" class="text-center"><?php echo app('translator')->get('global.no_products'); ?></td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.shop_name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.category'); ?></th>
                                                        <th><?php echo app('translator')->get('global.price'); ?></th>
                                                        
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.approved'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($products->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>
    <div class="modal fade" id="disapproveModal" tabindex="-1" role="dialog" aria-labelledby="disapproveModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="<?php echo e('disapprove'); ?>" id="commentForm">
                    <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="commentForm">Add Comment</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="comment">Comment(Ar)</label>
                        <textarea class="form-control" rows="5" name="comment" id="comment"></textarea>
                    </div>
                </div>

                    <div class="modal-body">
                        <div class="form-group">
                            <label for="comment">Comment(En)</label>
                            <textarea class="form-control" rows="5" name="comment_en" id="comment_en"></textarea>
                        </div>
                    </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-secondary" data-dismiss="modal" id="btn-submit-comment">Send</button>
                </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/users-management/products/index.blade.php ENDPATH**/ ?>