<?php $__env->startSection('breadcrumbs'); ?>
    <h2 class="content-header-title float-left mb-0"><?php echo app('translator')->get('sidebar.shops'); ?></h2>
    <div class="breadcrumb-wrapper col-12">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>"><?php echo app('translator')->get('sidebar.dashboard'); ?></a>
            </li>
            <li class="breadcrumb-item"><a href="#"><?php echo app('translator')->get('sidebar.users_management'); ?></a>
            </li>
            <li class="breadcrumb-item active"><a href="<?php echo e(route('shops.index')); ?>"><?php echo app('translator')->get('sidebar.shops'); ?></a>
            </li>
        </ol>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="users-list-wrapper">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?php echo app('translator')->get('global.filters'); ?></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <div class="users-list-filter">
                        <form action="<?php echo e(route("shops.index")); ?>">
                            <div class="row">
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.name'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="name" value="<?php echo e(request()->input('name')); ?>" autocomplete="off" placeholder="<?php echo app('translator')->get('global.name'); ?>">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.shop_name'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="shop_name" value="<?php echo e(request()->input('shop_name')); ?>" autocomplete="off" placeholder="<?php echo app('translator')->get('global.shop_name'); ?>">
                                    </fieldset>
                                </div>
                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-role"><?php echo app('translator')->get('global.phone'); ?></label>
                                    <fieldset class="form-group">
                                        <input class="form-control" name="phone" value="<?php echo e(request()->input('phone')); ?>" autocomplete="off">
                                    </fieldset>
                                </div>

                                <div class="col-12 col-sm-3 col-lg-3">
                                    <label for="users-list-verified"><?php echo app('translator')->get('global.active'); ?></label>
                                    <fieldset class="form-group">
                                        <select class="form-control" name="is_active" id="users-list-verified">
                                            <option value=""><?php echo app('translator')->get('global.all'); ?></option>
                                            <option value="1" <?php echo e(request()->input('is_active') === "1" ? "selected" : ""); ?>><?php echo app('translator')->get('global.active'); ?></option>
                                            <option value="0" <?php echo e(request()->input('is_active') === "0" ? "selected" : ""); ?>><?php echo app('translator')->get('global.not_active'); ?></option>
                                        </select>
                                    </fieldset>
                                </div>

                            </div>
                            <div class="d-flex justify-content-center">
                                <button class="btn btn-primary" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('global.search'); ?></button>
                                <a href="<?php echo e(route('shops.index')); ?>" class="btn btn-primary text-white mx-2"><i class="fa fa-times"></i>
                                    <?php echo app('translator')->get('global.clear_search'); ?>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"></h4>
                <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i class="feather icon-chevron-down"></i></a></li>

                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <div class="card-body">
                    <section id="column-selectors">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row col-12">
                                            <div class="col-10" id="dataTableExport"></div>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shops_create')): ?>
                                                <div class="col-2 text-right">
                                                    <a href="<?php echo e(route('shops.create')); ?>" class="btn bg-gradient-primary waves-effect waves-light">جديد</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="card-content">
                                        <div class="card-body card-dashboard">
                                            <div class="table-responsive">
                                                <table class="table table-striped datatableInit nowrap">
                                                    <thead>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.manager_name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.shop_name_arabic'); ?></th>
                                                        <th><?php echo app('translator')->get('global.shop_name_english'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone'); ?></th>
                                                        <th><?php echo app('translator')->get('global.products_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active_categories_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone_confirmed'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php $__empty_1 = true; $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <tr class="text-center">
                                                            <td><?php echo e($loop->iteration); ?></td>
                                                            <td>
                                                                <div class="pr-1">
                                                                        <span class="avatar m-0 avatar-md">
                                                                            <a href="<?php echo e($shop->default_image); ?>" class="mpImage">
                                                                                <img class="media-object rounded-circle" src="<?php echo e($shop->default_image); ?>" height="42" width="42" alt="Generic placeholder image">
                                                                            </a>
                                                                            <i></i>
                                                                        </span>
                                                                </div>
                                                            </td>
                                                            <td><?php echo e($shop->name); ?></td>
                                                            <td><?php echo e($shop->shop_name); ?></td>
                                                            <td><?php echo e($shop->shop_name_en); ?></td>
                                                            <td style="direction: ltr"><?php echo e($shop->phone_with_code); ?></td>
                                                            <td><a href="<?php echo e(route('products.index',['user_id'=>$shop->id])); ?>"><?php echo e($shop->products_count); ?></a></td>
                                                            <td><a href="<?php echo e(route('categories.index',['user_id'=>$shop->id])); ?>"><?php echo e($shop->active_categories_count); ?></a></td>

                                                            <td><i class="fa fa-<?php echo e($shop->phone_verified_at ? "check text-success" : "times text-danger"); ?>"></i></td>
                                                            <td class="is_active"><i class="fa fa-<?php echo e($shop->is_active ? "check text-success" : "times text-danger"); ?>"></i></td>
                                                            <td>
                                                                <div class="d-inline-flex action-btn">
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shops_edit')): ?>
                                                                        <a href="<?php echo e(route('shops.edit', $shop->id)); ?>" title="<?php echo app('translator')->get('global.edit'); ?>" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></a>
                                                                        <?php if($shop->is_active): ?>
                                                                            <a href="#" title="<?php echo app('translator')->get('global.deactivate'); ?>" data-id="<?php echo e($shop->id); ?>" data-route="<?php echo e(route('toggleShopStatus')); ?>" data-message="<?php echo app('translator')->get('global.deactivate_shop'); ?>" data-alt-msg="<?php echo app('translator')->get('global.activate_shop'); ?>" class="btn btn-dark  btn-sm toggleIsActive"><i class="fas fa-thumbs-down"></i></a>
                                                                        <?php else: ?>
                                                                            <a href="#" title="<?php echo app('translator')->get('global.activate'); ?>" data-id="<?php echo e($shop->id); ?>" data-route="<?php echo e(route('toggleShopStatus')); ?>" data-message="<?php echo app('translator')->get('global.activate_shop'); ?>" data-alt-msg="<?php echo app('translator')->get('global.deactivate_shop'); ?>" class="btn btn-success  btn-sm toggleIsActive"><i class="fas fa-thumbs-up"></i></a>
                                                                        <?php endif; ?>
                                                                    <?php endif; ?>
                                                                    
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shops_delete')): ?>
                                                                        <form action="<?php echo e(route('shops.destroy', $shop->id)); ?>" method="post">
                                                                            <?php echo method_field("delete"); ?>
                                                                            <?php echo csrf_field(); ?>
                                                                            <button class="btn btn-sm btn-danger deleteBtn" type="button" title="<?php echo app('translator')->get('global.delete'); ?>"><i class="fas fa-trash"></i></button>
                                                                        </form>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <tr>
                                                            <td colspan="10" class="text-center"><?php echo app('translator')->get('global.no_shops'); ?></td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <tr></tr>
                                                    </tbody>
                                                    <tfoot>
                                                    <tr class="text-center">
                                                        <th>#</th>
                                                        <th><?php echo app('translator')->get('global.image'); ?></th>
                                                        <th><?php echo app('translator')->get('global.manager_name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.shop_name_ar'); ?></th>
                                                        <th><?php echo app('translator')->get('global.shop_name'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone'); ?></th>
                                                        <th><?php echo app('translator')->get('global.products_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active_categories_count'); ?></th>
                                                        <th><?php echo app('translator')->get('global.phone_confirmed'); ?></th>
                                                        <th><?php echo app('translator')->get('global.active'); ?></th>
                                                        <th><?php echo app('translator')->get('global.actions'); ?></th>
                                                    </tr>
                                                    </tfoot>
                                                </table>
                                            </div>
                                            <div class="pagination">
                                                <?php echo e($shops->appends(request()->input())->links()); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Blockat/resources/views/dashboard/users-management/shops/index.blade.php ENDPATH**/ ?>